function displayModal(sign) {
   if (sign) {
      $("div#modal").fadeIn(200);
   } else {
      $("div#modal").fadeOut(100);
      loginCheck();
   }

   return false;
}
function adjustCenter(target) {
   var margin_top  = ($(window).height()-$(target).height())/2;
   var margin_left = ($(window).width()-$(target).width())/2;
   $(target).css({top:margin_top+"px", left:margin_left+"px"});

   return false;
}
function setModal(url, width, height, sign) {
   $(document).on("click", ".modal", function() {
      if ($(this).data('modalWidth') != void 0) {
         $(".modal_main").css('width', $(this).data('modalWidth'));
      }
      if ($(this).data('modalHeight') != void 0) {
         $(".modal_main").css('height', $(this).data('modalHeight'));
      }
      adjustCenter(".modal_main");
      $(".modal_main").load($(this).attr("href"));

      displayModal(true);
      return false;
   });

   if (url != void 0){
      if (width != void 0) {
         $(".modal_main").css('width', width+'px');
      }
      if (height != void 0) {
         $(".modal_main").css('height', height+'px');
      }
      adjustCenter(".modal_main");
      $(".modal_main").load(url);

      displayModal(true);
   }

   var clickFalse = function() {displayModal(false);}
   var keyupFalse = function(e){if (e.keyCode == 27){displayModal(false);}}
   if (sign) {
      $(document).off("click", ".modal_close");
      $(document).off("click", ".modal_back");
      $(document).off("keyup");
      $(".modal_back").css("cursor", "default");
   } else {
      $(document).on("click", ".modal_close", clickFalse);
      $(document).on("click", ".modal_back", clickFalse);
      $(document).on("keyup", keyupFalse);
      $(".modal_back").css("cursor", "pointer");
   }

   return false;
}





function loginCheck(){
   if ($("header .info").size() < 1){return false;}

   $('header .info').html('');
   $('.view_scroll_top table tr td.info').html('');
   $.getJSON('/ajax/login', function(res) {
      if (res.status == 'success') {
         $('header .info').append(''
            + '<div class="left w50">'
               + '<a href="/home/index">'
                  + '<img class="icon_url" src="'+ res.user.icon_url + '">'
               +'</a>'
            + '</div>'
            + '<div class="left w150 pl10 pr10">'
               + '<h5>UserID : ' + res.user.id + '</h5>'
               + '<p><a href="/home/index">' + res.user.name + '</a></p>'
            + '</div>'
            + '<div class="right w60">'
                + '<a href="/logout-modal" class="modal btn" data-modal-width="320px" data-modal-height="180px">Logout</a>'
             + '</div>'
         );
         $('.view_scroll_top table tr td.info').append(''
            + '<div class="view">'
               + '<a href="/home/index">'
                  + '<img class="icon_url" src="'+ res.user.icon_url +'">'
                  + res.user.name
               + '</a>'
            + '</div>'
            + '<div class="button">'
                + '<a href="/logout-modal" class="modal btn" data-modal-width="320px" data-modal-height="180px">Logout</a>'
            + '</div>'
         );
         iconUrl();
      } else {
         $('header .info').append(''
            + '<dl class="left w220">'
               + '<dt>'+$('header .info').data('login')+'</dt>'
               + '<dd>'
                  + '<span class="twitter">Twitter</span>'
                  + '<span class="facebook">Facebook</span>'
                  + '<span class="github">Github</span>'
               + '</dd>'
            + '</dl>'
            + '<div class="right w60">'
               + '<a href="/login-modal" class="modal btn_red" data-modal-width="320px" data-modal-height="180px">Login</a>'
            + '</div>'
         );
         $('.view_scroll_top table tr td.info').append(''
            + '<div class="view">'
               + '<p>'+ $('.view_scroll_top table tr td.info').data('login') +'</p>'
            + '</div>'
            + '<div class="button">'
               + '<a href="/login-modal" class="modal btn_red" data-modal-width="320px" data-modal-height="180px">Login</a>'
            + '</div>'
         );
      }
   });

   return false;
}



$(document).ready(function(){
   setModal();
   loginCheck();
   return false;
})
$(window).resize(function() {
   adjustCenter(".modal_main");
   return false;
});
